unit f_Report1;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  uCustomReportFactory, uReportFactory, uAbstractAppConfig, uAppConfig,
  uCustomAIMFactoryConfig, uCommonAIMFactoryConfig, uAIMFactoryConfig, uReport;

type
  TCustomerData = class(TComponent)
  private
    FCustomerName: string;
    FAdress: string;
    FNumber: integer;
    FVIP: boolean;
  public
    constructor Create(AOwner: TComponent); override;
    procedure Init(AName: string; ANum: integer; AAdr: string; AVIP: boolean);
  published
    property Number: integer read FNumber write FNumber;
    property CustomerName: string read FCustomerName write FCustomerName;
    property Adress: string read FAdress write FAdress;
    property VIP: boolean read FVIP write FVip;
  end;

  TfmReport1 = class(TForm)
    ReportFactory1: TReportFactory;
    AIMFactoryConfig1: TAIMFactoryConfig;
    procedure ReportFactory1ReportDragOver(Sender, Source: TObject;
      ADOESenderType: TDOESenderType; X, Y: Integer;
      var AObjProperties: TReportObjectProperties);
  private
    FObjects: array[0..3] of TCustomerData;
    FBatchList: array[0..1] of TList;
    function getCorrectObject(AType: TDOESenderType; AObj: TObject): TObject;
  public
    constructor Create(AOwner: TComponent); override;
    property ReportFactory: TReportFactory read ReportFactory1 write ReportFactory1;
    property FactoryConfig: TAIMFactoryConfig read AIMFactoryConfig1 write AIMFactoryConfig1;
  end;

var
  fmReport1: TfmReport1;

implementation

{$R *.DFM}

uses
  ExtCtrls;


constructor TCustomerData.Create(AOwner: TComponent);
begin
  inherited;
  FAdress := '';
  FNumber := 0;
  FVIP := false;
end;

procedure TCustomerData.Init(AName: string; ANum: integer; AAdr: string; AVIP: boolean);
begin
  FCustomerName := AName;
  FAdress := AAdr;
  FNumber := ANum;
  FVIP := AVIP;
end;

constructor TfmReport1.Create(AOwner: TComponent);
begin
  inherited;
  FObjects[0] := TCustomerData.Create(self);
  FObjects[0].Init('Customer Name', 0, 'Customer Adress', false);
  FObjects[0].Name := 'Customer1';
  FObjects[1] := TCustomerData.Create(self);
  FObjects[1].Init('AB', 2, 'XXXX XXX', true);
  FObjects[1].Name := 'Customer2';
  FObjects[2] := TCustomerData.Create(self);
  FObjects[2].Init('CD', 3, 'YYYY YYY', false);
  FObjects[2].Name := 'Customer3';
  FObjects[3] := TCustomerData.Create(self);
  FObjects[3].Init('EF', 4, 'Z Z Z Z Z', true);
  FObjects[3].Name := 'Customer4';
  FBatchList[0] := TList.Create;
  with FBatchList[0] do
  begin
    Add(FObjects[1]);
    Add(FObjects[2]);
    Add(FObjects[3]);
  end;
  FBatchList[1] := TList.Create;
  with FBatchList[1] do
  begin
    Add(FObjects[2]);
    Add(FObjects[3]);
  end;
end;

function TfmReport1.getCorrectObject(AType: TDOESenderType; AObj: TObject): TObject;
var
  lT: integer;

begin
  Result := AObj;
  if AObj is TComponent then
  begin
    lT := TComponent(AObj).Tag;
    if (AType = doeReport) or (AType = doeRITemplate) then
      if lT < 5 then
        Result := FObjects[0];

    if (AType = doeRIBatch) then
      case lT of
        5: Result := FBatchList[0];
        6: Result := FBatchList[1];
      end;
  end;
end;

procedure TfmReport1.ReportFactory1ReportDragOver(Sender, Source: TObject;
  ADOESenderType: TDOESenderType; X, Y: Integer;
  var AObjProperties: TReportObjectProperties);
begin
  with AObjProperties do
  begin
    ObjPtr := getCorrectObject(ADOESenderType, ObjPtr);
    if ObjPtr is TComponent then
      ObjCaption := TComponent(ObjPtr).Name;
  end;
end;

end.

